var renderClass = "jp.ngt.rtm.render.VehiclePartsRenderer";
importPackage(Packages.org.lwjgl.opengl);
importPackage(Packages.jp.ngt.rtm.render);
importPackage(Packages.jp.ngt.ngtlib.math);



//##### 初期化 ###########################
//マイクラ起動時に一度だけ実行されます
function init(par1, par2){
	
	//init内で定義した変数は使い回せるので固定値などはここで設定しておくと良
	
	//車両設定
	//連想配列でcfg["doorMove1"]のように呼び出して使える
	cfg = {};
	cfg.y0 = -0.7013 //車軸Ｙ位置
	cfg.z1 = 0.50 //車軸１ Ｚ位置
	cfg.z2 = -0.50 //車軸２ Ｚ位置
	
	frame = renderer.registerParts(new Parts("body")); //台車枠
	wheel1 = renderer.registerParts(new Parts("wheelF")); //車輪１
	wheel2 = renderer.registerParts(new Parts("wheelB")); //車輪２
}



function render(entity, pass, par3){

	GL11.glPushMatrix();
	
	//RTM側で車輪の回転を処理してくれるメソッド
	//jsonに "wheelRotationSpeed" の設定項目が必要
	//"wheelRotationSpeed" : 0.4607 ÷ 車輪半径(m)
	var f0 = renderer.getWheelRotationR(entity);

	//台車枠
	frame.render(renderer);
	
	//車輪１
	GL11.glPushMatrix();
	renderer.rotate(f0, 'X', 0.0, cfg["y0"], cfg["z1"]);
	wheel1.render(renderer);
	GL11.glPopMatrix();

	//車輪２
	GL11.glPushMatrix();
	renderer.rotate(f0, 'X', 0.0, cfg["y0"], cfg["z2"]);
	wheel2.render(renderer);
	GL11.glPopMatrix();

	GL11.glPopMatrix();
}
